/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Achievement
**
** DESCRIPTION:	Maintains completion status of achievements
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ACHIEVEMENT_H
#define ACHIEVEMENT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EAchievement
{
	eAchievement_AbundantSecurity = 0,
	eAchievement_AncientElder,
	eAchievement_AlchemyRUs,
	eAchievement_ChildProdigy,
	eAchievement_JackOfAll,
	eAchievement_FungusAmongUs,
	eAchievement_LegendaryLeader,
	eAchievement_ProlificProcreation,
	eAchievement_TechWonders,
	eAchievement_TheDoctorIsIn,

	eAchievement_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CAchievement
{
private:

	//class structures
	struct SAchievement
	{
		bool			m_bIsComplete;
		unsigned int	m_uiCompletionTime;
	};

public:

	struct SSaveState
	{
		SAchievement	m_sAchievement[eAchievement_NumberOf];
	};

private:

	//class data
	SAchievement		m_sAchievement[eAchievement_NumberOf];

	//class methods
	//setup
	public:		CAchievement(void);
	public:		void Reset();
	public:		const bool LoadState(SSaveState &sSaveState);
	public:		const bool SaveState(SSaveState &sSaveState);

	// process
	
	// access
	public:		void SetComplete(const EAchievement eAchievement);
	public:		const bool IsComplete(const EAchievement eAchievement) const;
	public:		const int AchievementsComplete() const;
	public:		const int CompletionTime(const EAchievement eAchievement) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CAchievement		Achievement;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/